<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
/**
 *
 * Brand Logo Widget .
 *
 */
class tourm_Brand_Logo extends Widget_Base {

	public function get_name() {
		return 'tourmbrandlogo';
	}
	public function get_title() {
		return __( 'Brand Logo', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'client_logo_section',
			[
				'label' 	=> __( 'Brand Logo', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] );

		// tourm_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Title', [ '1' ] );
		// tourm_general_fields( $this, 'desc', 'Description', 'TEXTAREA', 'Description', [ '1' ] );

		$fields_to_include = [ 'image' => ['Brand Logo'], 'url' => ['Link'] ];
		tourm_repeater_fields( $this, 'logos', 'Brand Logos', $fields_to_include );

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------General Style-------
		// $this->start_controls_section(
		// 	'general_styling',
		// 	[
		// 		'label'     => __( 'General', 'tourm' ),
		// 		'tab'       => Controls_Manager::TAB_STYLE,
		// 	]
		// );

		// tourm_color_fields( $this, 'bg', 'Background', 'background', '{{WRAPPER}} .brand-slider, {{WRAPPER}} .brand-sec', ['1', '2'] );  
		// // tourm_color_fields( $this, 'bg2', 'Background', 'background', '{{WRAPPER}} .brand-sec', ['2'], '--title-color' );  
		// tourm_color_fields( $this, 'bg4', 'Background 2', 'background', '{{WRAPPER}} .brandSlider1', ['1'] );  
		// tourm_color_fields( $this, 'bg3', 'Background Shage', 'background', '{{WRAPPER}} .brand-sec .brand-shape', ['2'] );  

		// $this->end_controls_section();

		// tourm_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title', [ '1' ] );
		// tourm_common_style_fields( $this, 'desc', 'Description', '{{WRAPPER}} .desc', [ '1' ] );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="container th-container">';
	            echo '<div class="swiper th-slider brandSlider1" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"6"},"1400":{"slidesPerView":"8"}}}\'>';
	                echo '<div class="swiper-wrapper">';
	                	foreach( $settings['logos'] as $data ){
		                    echo '<div class="swiper-slide">';
		                        echo '<div class="brand-box">';
		                            echo '<a href="">';
		                            	echo tourm_img_tag( array(
											'url'   => esc_url( $data['brand_logo']['url'] ),
											'class' => 'original'
										) );
										echo tourm_img_tag( array(
											'url'   => esc_url( $data['brand_logo']['url'] ),
											'class' => 'gray'
										) );
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';
		}
	}
}