<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Tourm_Cart extends Widget_Base {

	public function get_name() {
		return 'tourmcart';
	}
	public function get_title() {
		return __( 'Tourm Cart List', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Cart', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] );

		$fields_to_include = [ 'image' => ['Thumb Image'], 'title' => ['Title'] ];
		tourm_repeater_fields( $this, 'cat_list', 'Tour Cart Lists', $fields_to_include, ['1'] );


       $this->end_controls_section();

      	//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		// tourm_common_style_fields( $this, 'num', 'Number', '{{WRAPPER}} .num', ['1'] );
		// tourm_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title', ['1'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
       
		if( $settings['layout_style'] == '1' ){
			echo '<div class="img-box9 ">';
                echo '<div class="row gx-30">';
                	$i = 0;
                    foreach( $settings['cat_list'] as $data ){
                    	$i++;
                    	$mt = $i == 1 ? '' : 'mt-60';
	                    echo '<div class="col-sm-6">';
	                        echo '<div class="about-item2 '.esc_attr( $mt ).'">';
				                echo '<div class="img1">';
				                	if(!empty($data['thumb_image']['url'])){
					                    echo tourm_img_tag( array(
											'url'   => esc_url( $data['thumb_image']['url'] ),
										));
					                    echo '<a href="'.esc_url( $data['thumb_image']['url'] ).'" class="icon-btn popup-image"><i class="fa-solid fa-arrow-down-left-and-arrow-up-right-to-center"></i></a>';
					                }
				                echo '</div>';
				                if(!empty( $data['title'] )){
					                echo '<div class="box-content">';
					                    echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
					                echo '</div>';
					            }
				            echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';	
		}
	}
}