<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Tour Destinations Widget .
 *
 */
class tourm_Tour_Destinations extends Widget_Base {

	public function get_name() {
		return 'tourmdestinations';
	}
	public function get_title() {
		return __( 'Tour Destinations', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Tour Destinations', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six', 'Style Seven', 'Style Eight', 'Style Nine', 'Style Ten', 'Style Eleven', 'Style Twelve'] );


		$fields_to_include = [ 'image' => ['Thumb Image'], 'title' => ['Title', 'Total Trip'],'btn' => ['Button Text'], 'url' => ['URL'] ];
		tourm_repeater_fields( $this, 'cat_list', 'Tour Destinations Lists', $fields_to_include, ['1','2','3','4','5','6','7','8','9','10','11','12'] );

		tourm_media_fields( $this, 'shape', 'Shape Image', ['9'] );

		tourm_switcher_fields( $this, 'is_slider', 'Show Slider?', ['3'] );

		tourm_general_fields($this, 'arrow_id', 'Arrow ID or Class', 'TEXT', '#serviceSlider2',[ '8']);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .title a', ['1','2','3','4','5','6','7','8','10'] );
		tourm_common2_style_fields( $this, 'title3', 'Trip', '{{WRAPPER}} .trip_count', ['1','2','3','5','6','7'] );
		tourm_button_style_fields(  $this, '12', 'Button Styling', '{{WRAPPER}} .th-btn .style2', ['5']);
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="slider-area slider-drag-wrap">';
				echo '<div class="swiper th-slider destination-slider " id="aboutSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"}},"effect":"coverflow","coverflowEffect":{"rotate":"0","stretch":"95","depth":"212","modifier":"1"},"centeredSlides":"true"}\'>';
	                echo '<div class="swiper-wrapper">';

	                	foreach( $settings['cat_list'] as $data ){
		                    echo '<div class="swiper-slide">';
		                        echo '<div class="destination-box">';
		                            echo '<div class="destination-img">';
		                            	if(!empty($data['thumb_image']['url'])){
			                                echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
			                            }
		                                echo '<div class="destination-content">';
		                                    echo '<div class="media-left">';
		                                    	if(!empty($data['title'])){
			                                        echo '<h4 class="box-title title">';
			                                            echo '<a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a>';
			                                        echo '</h4>';
			                                    }
			                                    if(!empty($data['total_trip'])){
			                                        echo '<span class="destination-subtitle trip_count">'.esc_html($data['total_trip']).'</span>';
			                                    }
		                                    echo '</div>';
		                                    echo '<div class="">';
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style2 th-icon">'.esc_html($data['button_text']).'</a>';
		                                    echo '</div>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
	            echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="destination-list-area">';

				$lastKey = array_key_last( $settings['cat_list'] );

                foreach( $settings['cat_list'] as $key =>$data ){  
                	 $class = ($key === $lastKey) ? 'active' : '';

	                echo '<div class="destination-list-wrap '.esc_attr( $class ).'">';
	                	if(!empty($data['thumb_image']['url'])){
		                    echo '<div class="destination-list" data-bg-src="'.esc_url( $data['thumb_image']['url'] ).'">';
		                        echo '<div class="destination-content">';
		                        	if(!empty($data['title'])){
			                            echo '<h4 class="box-title title">';
			                                echo '<a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a>';
			                            echo '</h4>';
			                        }
		                            if(!empty($data['total_trip'])){
			                            echo '<span class="destination-subtitle trip_count">'.esc_html($data['total_trip']).'</span>';
			                        }
		                        echo '</div>';
		                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text']).'</a>';
		                    echo '</div>';
		                }
	                echo '</div>';
	            }
                

            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			if( $settings['is_slider'] == 'yes' ){
				echo '<div class="slider-area">';
	                echo '<div class="swiper th-slider has-shadow" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
	                    echo '<div class="swiper-wrapper">';
	                        foreach( $settings['cat_list'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="destination-item th-ani">';
		                            	if(!empty($data['thumb_image']['url'])){
			                                echo '<div class="destination-item_img global-img">';
			                                    echo tourm_img_tag( array(
													'url'   => esc_url( $data['thumb_image']['url'] ),
												));
			                                echo '</div>';
			                            }
		                                echo '<div class="destination-content">';
		                                	if(!empty($data['title'])){
			                                    echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
			                                }
			                                if(!empty($data['total_trip'])){
			                                    echo '<p class="destination-text trip_count">'.esc_html($data['total_trip']).'</p>';
			                                }
		                                    echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4 th-icon">'.esc_html($data['button_text']).'</a>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
	        }else{
	        	echo '<div class="row gy-4 gx-4">';
		        	foreach( $settings['cat_list'] as $data ){
	                    echo '<div class="col-xl-3 col-lg-4 col-md-6">';
	                        echo '<div class="destination-item th-ani">';
	                        	if(!empty($data['thumb_image']['url'])){
	                                echo '<div class="destination-item_img global-img">';
	                                    echo tourm_img_tag( array(
											'url'   => esc_url( $data['thumb_image']['url'] ),
										));
	                                echo '</div>';
	                            }
	                            echo '<div class="destination-content">';
	                            	if(!empty($data['title'])){
	                                    echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
	                                }
	                                if(!empty($data['total_trip'])){
	                                    echo '<p class="destination-text trip_count">'.esc_html($data['total_trip']).'</p>';
	                                }
	                                echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4 th-icon">'.esc_html($data['button_text']).'</a>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
	                echo '</div>';
	        }
		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow categorySlider4" id="categorySlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"5"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['cat_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="category-card style2">';
	                                echo '<div class="box-img global-img">';
	                                    if(!empty($data['thumb_image']['url'])){
			                                echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
			                            }
	                                echo '</div>';
	                                if(!empty($data['title'])){
		                                echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                            }
	                                echo '<a class="line-btn" href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['button_text']).'e</a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }

                        
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="row">';
                echo '<div class="destination-list-area">';

                    $i = 0;
	                foreach( $settings['cat_list'] as $key =>$data ){  
	                	$i++;
	                	$class = $i == 1 ? 'active' : '';

	                    echo '<div class="destination-list-wrap style2 '.esc_attr( $class ).'">';
	                    	if(!empty($data['thumb_image']['url'])){
		                        echo '<div class="destination-list" data-bg-src="'.esc_url( $data['thumb_image']['url'] ).'">';
		                            echo '<div class="destination-content">';
		                                if(!empty($data['title'])){
				                            echo '<h4 class="box-title title">';
				                                echo '<a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a>';
				                            echo '</h4>';
				                        }
		                                if(!empty($data['total_trip'])){
				                            echo '<span class="destination-subtitle trip_count">'.esc_html($data['total_trip']).'</span>';
				                        }
		                            echo '</div>';
		                            echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text']).'</a>';
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="destinationSlider6" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['cat_list'] as $key =>$data ){  
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="destination-item2 th-ani">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="box-img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="box-content">';
	                                    if(!empty($data['title'])){
			                                echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
			                            }
			                            if(!empty($data['total_trip'])){
		                                    echo '<p class="box-text trip_count">'.esc_html($data['total_trip']).'</p>';
		                                }
	                                echo '</div>';
	                           echo ' </div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<button data-slider-prev="#destinationSlider6" class="slider-arrow slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow2.svg" alt=""></button>';
                    echo '<button data-slider-next="#destinationSlider6" class="slider-arrow slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow2.svg" alt=""></button>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="destination-wrapper">';

                foreach( $settings['cat_list'] as $key =>$data ){          
	                echo '<div class="destination-item3">';
	                	if(!empty($data['thumb_image']['url'])){
		                    echo '<div class="destination-img">';
		                        echo tourm_img_tag( array(
									'url'   => esc_url( $data['thumb_image']['url'] ),
								));
		                    echo '</div>';
		                }
	                    echo '<div class="destination-content">';
	                    	if(!empty($data['title'])){
                                echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
                            }
                            if(!empty($data['total_trip'])){
                                echo '<span class="destination-subtitle trip_count">'.esc_html($data['total_trip']).'</span>';
                            }
	                    echo '</div>';
	                echo '</div>';
	            }
                

            echo '</div>';
		}elseif( $settings['layout_style'] == '8' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="'.esc_attr($settings['arrow_id']).'" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"},"1300":{"slidesPerView":"6"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['cat_list'] as $key =>$data ){   
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="category-card style5 single2">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="box-img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                if(!empty($data['title'])){
		                                echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                            }
	                                echo '<a class="line-btn" href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['button_text']).'e</a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '9' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['cat_list'] as $key =>$data ){   
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="destination-item4 th-ani">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="destination-item4_img global-img" data-mask-src="'.esc_url( $settings['shape']['url'] ).'">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
		                            if(!empty($data['title'])){
		                                echo '<div class="destination-content">';
		                                    echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/location-dot4.svg" alt="">'.esc_html($data['title']).'</a></h3>';
		                                echo '</div>';
		                            }
	                                echo '<a href="'.esc_url( $data['url']['url'] ).'" class="icon-btn"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow4.svg" alt=""></a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '10' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow destinationSlider10" id="destinationSlider10" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"4"},"1300":{"slidesPerView":"5"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                    	foreach( $settings['cat_list'] as $key =>$data ){  
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="destination-item4 style2 th-ani">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="destination-item4_img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
		                            if(!empty($data['title'])){
		                                echo '<div class="destination-content">';
		                                    echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/location-dot4.svg" alt="">'.esc_html($data['title']).'</a></h3>';
		                                echo '</div>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
                echo '<div class="icon-box text-center mt-30">';
                    echo '<button data-slider-prev="#destinationSlider10" class="slider-arrow default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow2.svg" alt=""></button>';
                    echo '<button data-slider-next="#destinationSlider10" class="slider-arrow default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow2.svg" alt=""></button>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '11' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider destinationSlide9 has-shadow" id="destinationSlide9" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['cat_list'] as $key =>$data ){ 
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="destination-item4 th-ani">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="destination-item4_img global-img" data-mask-src="'.TOURAM_PLUGDIRURI . 'assets/img/shape.png">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
		                            if(!empty($data['title'])){
		                                echo '<div class="destination-content">';
		                                    echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/location-dot4.svg" alt="">'.esc_html($data['title']).'</a></h3>';
		                                echo '</div>';
		                            }
	                                echo '<a href="'.esc_url( $data['url']['url'] ).'" class="icon-btn"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow4.svg" alt=""></a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }

                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#destinationSlide9" class="slider-arrow style6 slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow2.svg" alt=""></button>';
                echo '<button data-slider-next="#destinationSlide9" class="slider-arrow style6 slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow2.svg" alt=""></button>';
            echo '</div>';
		}else{
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['cat_list'] as $key =>$data ){ 
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="destination-item4 style3 th-ani">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="destination-item4_img global-img" data-mask-src="'.TOURAM_PLUGDIRURI . 'assets/img/shape.png">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
		                            if(!empty($data['title'])){
		                                echo '<div class="destination-content">';
		                                    echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/location-dot4.svg" alt="">'.esc_html($data['title']).'</a></h3>';
		                                echo '</div>';
		                            }
	                                echo '<a href="'.esc_url( $data['url']['url'] ).'" class="icon-btn"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow4.svg" alt=""></a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}
	}
}