<?php
    /**
     * Class For Builder
     */
    class TourmBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'tourm_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'tourm-core',TOURAM_PLUGDIRURI.'assets/js/tourm-core.js',array( 'jquery' ),'1.0',true );
		}


        public function tourm_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'tourm_header_option',
                [
                    'label'     => __( 'Header Option', 'tourm' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'tourm_header_style',
                [
                    'label'     => __( 'Header Option', 'tourm' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'tourm' ),
    					'header_builder'       => __( 'Header Builder', 'tourm' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'tourm_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'tourm' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->tourm_header_choose_option(),
                    'condition' => [ 'tourm_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'tourm_footer_option',
                [
                    'label'     => __( 'Footer Option', 'tourm' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'tourm_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'tourm' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'tourm' ),
    				'label_off'     => __( 'No', 'tourm' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'tourm_footer_style',
                [
                    'label'     => __( 'Footer Style', 'tourm' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'tourm' ),
    					'footer_builder'       => __( 'Footer Builder', 'tourm' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'tourm_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'tourm_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'tourm' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->tourm_footer_build_choose_option(),
                    'condition' => [ 'tourm_footer_style' => 'footer_builder','tourm_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Tourm Builder', 'tourm' ),
            	esc_html__( 'Tourm Builder', 'tourm' ),
				'manage_options',
				'tourm',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('tourm', esc_html__('Footer Builder', 'tourm'), esc_html__('Footer Builder', 'tourm'), 'manage_options', 'edit.php?post_type=tourm_footerbuild');
			add_submenu_page('tourm', esc_html__('Header Builder', 'tourm'), esc_html__('Header Builder', 'tourm'), 'manage_options', 'edit.php?post_type=tourm_header');
			add_submenu_page('tourm', esc_html__('Tab Builder', 'tourm'), esc_html__('Tab Builder', 'tourm'), 'manage_options', 'edit.php?post_type=tourm_tab_builder');
			add_submenu_page('tourm', esc_html__('Megamenu', 'tourm'), esc_html__('Megamenu', 'tourm'), 'manage_options', 'edit.php?post_type=tourm_megamenu');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header , Footer  And Megamenu Builder Of This Theme','tourm' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'tourm' ),
				'singular_name'      => __( 'Footer', 'tourm' ),
				'menu_name'          => __( 'Tourm Footer Builder', 'tourm' ),
				'name_admin_bar'     => __( 'Footer', 'tourm' ),
				'add_new'            => __( 'Add New', 'tourm' ),
				'add_new_item'       => __( 'Add New Footer', 'tourm' ),
				'new_item'           => __( 'New Footer', 'tourm' ),
				'edit_item'          => __( 'Edit Footer', 'tourm' ),
				'view_item'          => __( 'View Footer', 'tourm' ),
				'all_items'          => __( 'All Footer', 'tourm' ),
				'search_items'       => __( 'Search Footer', 'tourm' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'tourm' ),
				'not_found'          => __( 'No Footer found.', 'tourm' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'tourm' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'tourm_footerbuild', $args );

			$labels = array(
				'name'               => __( 'Header', 'tourm' ),
				'singular_name'      => __( 'Header', 'tourm' ),
				'menu_name'          => __( 'Tourm Header Builder', 'tourm' ),
				'name_admin_bar'     => __( 'Header', 'tourm' ),
				'add_new'            => __( 'Add New', 'tourm' ),
				'add_new_item'       => __( 'Add New Header', 'tourm' ),
				'new_item'           => __( 'New Header', 'tourm' ),
				'edit_item'          => __( 'Edit Header', 'tourm' ),
				'view_item'          => __( 'View Header', 'tourm' ),
				'all_items'          => __( 'All Header', 'tourm' ),
				'search_items'       => __( 'Search Header', 'tourm' ),
				'parent_item_colon'  => __( 'Parent Header:', 'tourm' ),
				'not_found'          => __( 'No Header found.', 'tourm' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'tourm' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'tourm_header', $args );

			$labels = array(
				'name'               => __( 'Tab Builder', 'tourm' ),
				'singular_name'      => __( 'Tab Builder', 'tourm' ),
				'menu_name'          => __( 'Gesund Tab Builder', 'tourm' ),
				'name_admin_bar'     => __( 'Tab Builder', 'tourm' ),
				'add_new'            => __( 'Add New', 'tourm' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'tourm' ),
				'new_item'           => __( 'New Tab Builder', 'tourm' ),
				'edit_item'          => __( 'Edit Tab Builder', 'tourm' ),
				'view_item'          => __( 'View Tab Builder', 'tourm' ),
				'all_items'          => __( 'All Tab Builder', 'tourm' ),
				'search_items'       => __( 'Search Tab Builder', 'tourm' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'tourm' ),
				'not_found'          => __( 'No Tab Builder found.', 'tourm' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'tourm' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'tourm_tab_builder', $args );


			$labels = array(
				'name'               => __( 'Megamenu', 'tourm' ),
				'singular_name'      => __( 'Megamenu', 'tourm' ),
				'menu_name'          => __( 'Tourm Megamenu', 'tourm' ),
				'name_admin_bar'     => __( 'Megamenu', 'tourm' ),
				'add_new'            => __( 'Add New', 'tourm' ),
				'add_new_item'       => __( 'Add New Megamenu', 'tourm' ),
				'new_item'           => __( 'New Megamenu', 'tourm' ),
				'edit_item'          => __( 'Edit Megamenu', 'tourm' ),
				'view_item'          => __( 'View Megamenu', 'tourm' ),
				'all_items'          => __( 'All Megamenu', 'tourm' ),
				'search_items'       => __( 'Search Megamenu', 'tourm' ),
				'parent_item_colon'  => __( 'Parent Megamenu:', 'tourm' ),
				'not_found'          => __( 'No Megamenu found.', 'tourm' ),
				'not_found_in_trash' => __( 'No Megamenu found in Trash.', 'tourm' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'tourm_megamenu', $args );
		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'tourm_footerbuild' == $post->post_type || 'tourm_header' == $post->post_type || 'tourm_tab_build' == $post->post_type || 'tourm_megamenu' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function tourm_footer_build_choose_option(){

			$tourm_post_query = new WP_Query( array(
				'post_type'			=> 'tourm_footerbuild',
				'posts_per_page'	    => -1,
			) );

			$tourm_builder_post_title = array();
			$tourm_builder_post_title[''] = __('Select a Footer','tourm');

			while( $tourm_post_query->have_posts() ) {
				$tourm_post_query->the_post();
				$tourm_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $tourm_builder_post_title;

		}

		public function tourm_header_choose_option(){

			$tourm_post_query = new WP_Query( array(
				'post_type'			=> 'tourm_header',
				'posts_per_page'	    => -1,
			) );

			$tourm_builder_post_title = array();
			$tourm_builder_post_title[''] = __('Select a Header','tourm');

			while( $tourm_post_query->have_posts() ) {
				$tourm_post_query->the_post();
				$tourm_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $tourm_builder_post_title;

        }

    }

    $builder_execute = new TourmBuilder();