<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget . 
 *
 */
class Tourm_Header extends Widget_Base {

	public function get_name() {
		return 'tourmheader';
	}
	public function get_title() {
		return __( 'Header', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' 	=> __( 'Header', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',['Style One','Style Two','Style Three','Style Four','Style Five','Style Six'] );


		$this->add_control(
			'address',
			[
				'label' 		=> __( 'Address', 'tourm' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '245, Frankfurt. Germany', 'tourm' ),
				'condition'	=> ['layout_style' => ['1','6']]
			]
		);
		$this->add_control(
			'o_h',
			[
				'label' 		=> __( 'Office Hours', 'tourm' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '245, Frankfurt. Germany', 'tourm' ),
				'condition'	=> ['layout_style' => ['1','6']]
			]
		);


		$this->add_control(
			'show_language',
			[
				'label' 		=> __( 'Show Language?', 'tourm' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'tourm' ),
				'label_off' 	=> __( 'Hide', 'tourm' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['layout_style' => ['1','6']]
			]
		);

		

		$this->add_control(
			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'tourm' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);	



		$menus_header_top = $this->tourm_menu_select_for_header();

		if( !empty( $menus_header_top ) ){
	        $this->add_control(
				'tourm_menu_select_for_header',
				[
					'label'     	=> __( 'Select tourm header top Menu / Menu 1', 'tourm' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus_header_top,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'tourm' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'tourm' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'tourm' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}


		$menus = $this->tourm_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'tourm_menu_select',
				[
					'label'     	=> __( 'Select tourm header top Menu', 'tourm' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'tourm' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'tourm' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'tourm' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}
	
		$this->add_control(
			'show_offcanvas_btn',
			[
				'label' 		=> __( 'Show Offcanvas Button?', 'tourm' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'tourm' ),
				'label_off' 	=> __( 'Hide', 'tourm' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['layout_style' => ['2','3','4', '5','6']]
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'tourm' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'Contact Us', 'tourm' ),
				'condition'	=> ['layout_style' => ['1','4', '5','6']]
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'tourm' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'tourm' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['layout_style' => ['1','4', '5','6']]
			]
		);
		
		$repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' 	=> __( 'Social Icon', 'tourm' ),
				'type' 		=> Controls_Manager::ICONS,
				'default' 	=> [
					'value' 	=> 'fab fa-facebook-f',
					'library' 	=> 'solid',
				],
			]
		);

		$repeater->add_control(
			'icon_link',
			[
				'label' 		=> __( 'Link', 'tourm' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'tourm' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(

			'social_icon_list',
			[
				'label' 		=> __( 'Social Icon', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'social_icon' => __( 'Add Social Icon','tourm' ),
					],
				],
				'condition'	=> ['layout_style' => ['4']]
			]
		);

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------General Style-------
		 $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Background Styling', 'tourm' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );


		tourm_color_fields( $this, 'menu_bg', 'Background', 'background', '{{WRAPPER}} .header-layout-control, {{WRAPPER}} .header-layout-control .sticky-wrapper', ['1','2'] );         
      
       

		$this->end_controls_section();

		//------Menu Bar Style-------
        $this->start_controls_section(
			'menubar_styling2',
			[
				'label'     => __( 'Menu Styling', 'tourm' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		tourm_color_fields( $this, 'menu_color1', 'Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a', ['1','2','3'] );
		tourm_color_fields( $this, 'menu_color2', 'Hover Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a:hover', ['1','2','3'] );
		tourm_color_fields( $this, 'menu_color3', 'Dropdown Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a' );
		tourm_color_fields( $this, 'menu_color4', 'Dropdown Hover Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:hover' );
		tourm_color_fields( $this, 'menu_color5', 'Menu Icon Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:before, {{WRAPPER}} .main-menu ul li.menu-item-has-children > a:after' );

		tourm_typography_fields( $this, 'menu_font', 'Menu Trpography', '{{WRAPPER}} .main-menu>ul>li>a, {{WRAPPER}} .main-menu ul.sub-menu li a' );

		tourm_dimensions_fields( $this, 'menu_margin', 'Menu Margin', 'margin', '{{WRAPPER}} .main-menu>ul>li>a' );
		tourm_dimensions_fields( $this, 'menu_padding', 'Menu Padding', 'padding', '{{WRAPPER}} .main-menu>ul>li>a' );

		$this->end_controls_section();

		//------Button Style-------
		tourm_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .btn-mask, {{WRAPPER}} .th-btn' );

    }

    public function tourm_menu_select_for_header(){
	    $tourm_menu_header = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'tourm' );
	    foreach( $tourm_menu_header as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}



	public function tourm_menu_select(){
	    $tourm_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'tourm' );
	    foreach( $tourm_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

	

        //Menu by menu select
        $tourm_avaiable_menu_header   = $this->tourm_menu_select_for_header();
		if( ! $tourm_avaiable_menu_header ){
			return;
		}
		$args_for_header = [
			'menu' 			=> $settings['tourm_menu_select_for_header'],
			'menu_class' 	=> 'tourm-menu',
			'container' 	=> '',
		];



		//Menu by menu select
        $tourm_avaiable_menu   = $this->tourm_menu_select();
		if( ! $tourm_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['tourm_menu_select'],
			'menu_class' 	=> 'tourm-menu',
			'container' 	=> '',
		];

		//Mobile menu, Offcanvas, Search
        echo tourm_mobile_menu();
		// echo tourm_header_cart_offcanvas();
		if(!empty( $settings['show_offcanvas_btn'])){
			echo tourm_header_offcanvas();
		}
		// if(!empty( $settings['show_search_btn'])){
		// 	echo tourm_search_box();
		// }
		// Header sub-menu icon
		if( class_exists( 'ReduxFramework' ) ){ 
			if(tourm_opt('tourm_header_sticky')){
                $sticky = '';
            }else{
                $sticky = '-no';
            }

			if(tourm_opt('tourm_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}


		if( $settings['layout_style'] == '1' ){
			echo '<div class="th-header header-layout1 header-layout2">';
		        echo '<div class="header-top">';
		            echo '<div class="container th-container">';
		                echo '<div class="row justify-content-center justify-content-lg-between align-items-center">';
		                    echo '<div class="col-auto d-none d-md-block">';
		                        echo '<div class="header-links">';
		                            echo '<ul>';
		                            	if( ! empty( $settings['address'] ) ){
			                                echo '<li class="d-none d-xl-inline-block"><i class="fa-sharp fa-regular  fa-location-dot"></i>';
			                                    echo '<span>'.esc_html( $settings['address'] ).'</span>';
			                                echo '</li>';
			                            }
			                            if( ! empty( $settings['o_h'] ) ){
			                                echo '<li class="d-none d-xl-inline-block"><i class="fa-regular fa-clock"></i>';
			                                    echo '<span>'.esc_html( $settings['o_h'] ).'</span>';
			                                echo '</li>';
			                            }
		                            echo '</ul>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="col-auto">';
		                        echo '<div class="header-right">';
		                            if( ! empty( $settings['show_language'] ) ){
	                                    echo '<div class="dropdown-link">';
	                                        echo '<a class="dropdown-toggle" href="'.esc_url('#').'" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">'.esc_html__('Language', 'tourm').'</a> ';
	                                            echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">';
	                                                echo ' <li>';
	                                                echo do_shortcode('[gtranslate]');
	                                                echo ' </li>';
	                                        echo ' </ul>';
	                                    echo ' </div>';
	                                }
		                            echo '<div class="header-links">';
		                                if( ! empty( $settings['tourm_menu_select_for_header'] ) ){
											wp_nav_menu( $args_for_header );
										}
		                                
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		               echo ' </div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area" data-bg-src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/line-pattern.png">';
		                echo '<div class="container th-container">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                        	echo '<nav class="main-menu d-none d-xl-inline-block '.esc_attr($menu_icon).'">';
		                                if( ! empty( $settings['tourm_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                           	echo ' <button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-xl-block">';
		                            echo '<div class="header-button">';
		                            	if(!empty( $settings['button_text'])){
			                                echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style3 th-icon">'.wp_kses_post($settings['button_text']).'</a>';
			                            }

		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="th-header header-layout3 header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-xl-block '.esc_attr($menu_icon).'">';
		                                if( ! empty( $settings['tourm_menu_select_for_header'] ) ){
											wp_nav_menu( $args_for_header );
										}
		                            echo '</nav>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-xl-block '.esc_attr($menu_icon).'">';
										if( ! empty( $settings['tourm_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                   echo ' </div>';
		                echo '</div>';
		                if( ! empty( $settings['show_offcanvas_btn'] ) ){
			                echo '<div class="header-right-button">';
			                    echo '<a href="#" class="simple-btn sideMenuToggler"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/menu.svg" alt=""></a>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="th-header header-layout5">';
		        echo '<div class="sticky-wrapper">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		            	if( ! empty( $settings['show_offcanvas_btn'] ) ){
			                echo '<div class="header-button">';
			                    echo '<a href="#" class="simple-btn sideMenuToggler"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/menu.svg" alt=""></a>';
			                echo '</div>';
			            }
		                echo '<div class="container th-container3">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto ms-xl-auto">';
		                            
		                        	echo '<nav class="main-menu d-none d-xl-inline-block '.esc_attr($menu_icon).'">';
										if( ! empty( $settings['tourm_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';

		                            
		                            echo '<button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="logo-bg" data-mask-src="'.TOURAM_PLUGDIRURI . 'assets/img/logo_bg_mask.png"></div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="th-header header-layout3 header-layout9 header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container th-container5">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-wrapp">';
		                                echo '<div class="th-social">';
		                                    if( ! empty( $settings['social_icon_list'] ) ){
		                                        foreach( $settings['social_icon_list'] as $social_icon ){
						                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
						                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

						                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

						                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

						                          	echo '</a> ';
						                      	} 
				                            }
		                                echo '</div>';

		                                echo '<nav class="main-menu d-none d-xl-block '.esc_attr($menu_icon).'">';
			                                if( ! empty( $settings['tourm_menu_select_for_header'] ) ){
												wp_nav_menu( $args_for_header );
											}
			                            echo '</nav>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-wrapp">';

		                            	echo '<nav class="main-menu d-none d-xl-block '.esc_attr($menu_icon).'">';
											if( ! empty( $settings['tourm_menu_select'] ) ){
												wp_nav_menu( $args );
											}
			                            echo '</nav>';
		                                echo '<div class="header-button">';
		                                	if(!empty( $settings['button_text'])){
			                                    echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style2 th-icon">'.wp_kses_post($settings['button_text']).'</a>';
			                                }
		                                    if( ! empty( $settings['show_offcanvas_btn'] ) ){
			                                    echo '<a href="#" class="simple-btn sideMenuToggler"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/menu.svg" alt=""></a>';
			                                }
		                                echo '</div>';
		                                echo '<button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="th-header header-layout8">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container th-container5">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                           echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                        	echo '<nav class="main-menu d-none d-xl-block '.esc_attr($menu_icon).'">';
										if( ! empty( $settings['tourm_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-button">';
		                            	if(!empty( $settings['button_text'])){
		                                    echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style4 th-icon">'.wp_kses_post($settings['button_text']).'</a>';
		                                }
		                                if( ! empty( $settings['show_offcanvas_btn'] ) ){
			                                echo '<a href="#" class="simple-btn sideMenuToggler d-none d-xl-block"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/menu2.svg" alt=""></a>';
			                            }
		                                echo '<button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}else{
			echo '<div class="th-header header-layout1 header-layout11">';
		        echo '<div class="header-top">';
		            echo '<div class="container th-container">';
		                echo '<div class="row justify-content-center justify-content-lg-between align-items-center">';
		                    echo '<div class="col-auto d-none d-md-block">';
		                        echo '<div class="header-links">';
		                            echo '<ul>';
		                            	if( ! empty( $settings['address'] ) ){
			                                echo '<li class="d-none d-xl-inline-block"><i class="fa-sharp fa-regular  fa-location-dot"></i>';
			                                    echo '<span>'.esc_html( $settings['address'] ).'</span>';
			                                echo '</li>';
			                            }
			                            if( ! empty( $settings['o_h'] ) ){
			                                echo '<li class="d-none d-xl-inline-block"><i class="fa-regular fa-clock"></i>';
			                                    echo '<span>'.esc_html( $settings['o_h'] ).'</span>';
			                                echo '</li>';
			                            }
		                            echo '</ul>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="col-auto">';
		                        echo '<div class="header-right">';
		                            if( ! empty( $settings['show_language'] ) ){
	                                    echo '<div class="dropdown-link">';
	                                        echo '<a class="dropdown-toggle" href="'.esc_url('#').'" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">'.esc_html__('Language', 'tourm').'</a> ';
	                                            echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">';
	                                                echo ' <li>';
	                                                echo do_shortcode('[gtranslate]');
	                                                echo ' </li>';
	                                        echo ' </ul>';
	                                    echo ' </div>';
	                                }
		                            echo '<div class="header-links">';
		                                if( ! empty( $settings['tourm_menu_select_for_header'] ) ){
											wp_nav_menu( $args_for_header );
										}
		                                
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		               echo ' </div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container th-container">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                        	echo '<nav class="main-menu d-none d-xl-inline-block '.esc_attr($menu_icon).'">';
		                                if( ! empty( $settings['tourm_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                           	echo ' <button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-xl-block">';
		                            echo '<div class="header-button">';
		                            	if(!empty( $settings['button_text'])){
			                                echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style2 th-icon">'.wp_kses_post($settings['button_text']).'</a>';
			                            }
			                            if( ! empty( $settings['show_offcanvas_btn'] ) ){
			                                echo '<a href="#" class="simple-btn sideMenuToggler d-none d-xl-block"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/menu.svg" alt=""></a>';
			                            }
                                		echo '<button type="button" class="th-menu-toggle d-block d-xl-none"><i class="far fa-bars"></i></button>';

		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}