<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Widget .
 *
 */
class tourm_Video extends Widget_Base {

	public function get_name() {
		return 'tourmvideo';
	}
	public function get_title() {
		return __( 'Video Box', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'video Box', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two' ,'Style Three','Style Four' ] ); 

		


		tourm_general_fields( $this, 'video_url', 'Video Url', 'TEXT', '#' );
		tourm_general_fields( $this, 'v_title', 'Video Title', 'TEXTAREA2', 'travel Agency since in 1996.', [ '3'] );

		tourm_media_fields( $this, 'image', 'Choose Image', ['3','4']);
		
		tourm_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Watch Video', [ '3'] );

		// tourm_general_fields( $this, 'scroll_text', 'Scroll Text', 'TEXT', ' Scroll  Down', ['4'] );
		// tourm_general_fields( $this, 'idss', 'Scroll ID', 'TEXT', 'About', ['4'] );

		$this->end_controls_section();



        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		// tourm_common_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .sec-title', [ '1' ] );
	
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			if(!empty($settings['video_url'])){
				echo '<div class="video-box1">';
	                echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn style2 popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
	            echo '</div>';
	        }
		}elseif( $settings['layout_style'] == '2' ){
			if(!empty($settings['video_url'])){
				echo '<div class="video-box3">';
	                echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
	            echo '</div>';
	        }
		}elseif( $settings['layout_style'] == '3' ){

			$bg = $settings['image']['url'] ? $settings['image']['url'] : '#';

			echo '<div class="video-area2 overflow-hidden" data-bg-src="'.esc_url( $bg ).'">';
		        echo '<div class="container th-container">';
		            echo '<div class="video-box2">';
		            	if(!empty( $settings['title'] )){
			                echo '<h3 class="box-title">'.esc_html( $settings['title'] ).'</h3>';
			            }
		                echo '<div class="video-shape">';
		                    echo '<div class="discount-wrapp">';
		                    	if(!empty($settings['video_url'])){
			                        echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn popup-video">';
			                            echo '<i class="fa-solid fa-play"></i></a>';
			                    }
			                    if(!empty( $settings['v_title'] )){
			                        echo '<div class="discount-tag">';
			                            echo '<span class="discount-anime">'.esc_html( $settings['v_title'] ).'</span>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}else{
			if(!empty( $settings['image']['url'] )){
		        echo '<div class="hero-video-img hero13-video-img">';
		            echo '<img src="'.esc_url( $settings['image']['url'] ).'" alt="">';
		            if(!empty($settings['video_url'])){  
			            echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
			        }
		        echo '</div>';
		    }
		    // if( !empty( $settings['idss'] ) ){
		    //     echo '<div class="scroll-down">';
		    //         echo '<a href="'.esc_url( $settings['idss'] ).'" class="scroll-wrap"><span><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/down-arrow.svg" alt=""></span>'.esc_html($settings['scroll_text']).'</a>';
		                
		    //     echo '</div>';
		    // }
		}
	}
}